# ===========================
# Script : NewUpdateOpti - Version 4.5
# Auteur original : Julien
# Optimisation & Ajouts : Julien & Lirious 
# ===========================
Set-ExecutionPolicy -ExecutionPolicy Bypass -Scope Process

function Show-Message {
    param(
        [string]$fr,
        [string]$en,
        [string]$color = "White",
        [switch]$NoNewline
    )
    if ($global:language -eq 1) {
        if ($NoNewline) {
            Write-Host $en -ForegroundColor $color -NoNewline
        } else {
            Write-Host $en -ForegroundColor $color
        }
    } else {
        if ($NoNewline) {
            Write-Host $fr -ForegroundColor $color -NoNewline
        } else {
            Write-Host $fr -ForegroundColor $color
        }
    }
}


$language = 0
do {
     Write-Host "================================================================" -ForegroundColor Cyan
     Write-Host "                        Langue/Language                         " -ForegroundColor Yellow
     Write-Host "================================================================" -ForegroundColor Cyan

    Write-Host "================================================================" -ForegroundColor Yellow
    Write-Host "     Choisissez votre langue / Choose your language :           " -ForegroundColor Yellow
    Write-Host                            "0. Francais                          " -ForegroundColor Green
    Write-Host                            "1. English                           " -ForegroundColor Green
    Write-Host "================================================================" -ForegroundColor Yellow
    $langInput = Read-Host "Votre choix / Your choice (0 or 1)"
    if ($langInput -eq "0" -or $langInput -eq "1") {
        $global:language = [int]$langInput
        break
    } else {
        Write-Host "Veuillez entrer 0 ou 1 / Please enter 0 or 1." -ForegroundColor Red
    }
} while ($true)

Write-Host ""
Write-Host "================================================================" -ForegroundColor Yellow
Show-Message -fr "                  Introduction/Conditions                       " -en "                  Introduction / Terms                          " -color "White"
Write-Host "================================================================" -ForegroundColor Yellow
Write-Host ""

if ($global:language -eq 1) {
    Write-Output @"
Author: Julien/Lirious
Creation date: [18/08/2025]
Version: [4.5]
This PowerShell script is designed to update your Nvidia driver.
Its use is restricted to Discord server members with the 'Optimisation terminee' role.
Sharing this script with a third party will result in an automatic ban from the Discord server and loss of support.
"@
} else {
    Write-Output @"
Auteur: Julien/Lirious
Date de creation: [01/12/2025]
Version: [4.5]
Ce script en PowerShell est concu pour effectuer la mise a jour de votre driver Nvidia.
Son usage est limite aux membres du serveur Discord disposant du role Optimisation terminee.
Toute transmission de ce script a un tiers entrainera automatiquement un ban du serveur Discord ainsi qu'une perte de suivi.
"@
}


Write-Host ""
Write-Host "================================================================" -ForegroundColor Yellow
Show-Message -fr "                    Confirmation Utilisateur                    " -en "                    User Confirmation                           " -color "White"
Write-Host "================================================================" -ForegroundColor Yellow
Write-Host ""

do {
    if ($global:language -eq 1) {
        $confirmation = Read-Host "Please type 'ok' to confirm your agreement"
        if ($confirmation -ieq "ok") {
            Write-Host "[OK] Agreement accepted. The script continues." -ForegroundColor Green
            break
        } else {
            Write-Host "[!] You must type 'ok' to continue." -ForegroundColor Yellow
        }
    } else {
        $confirmation = Read-Host "Veuillez taper 'ok' pour confirmer votre accord"
        if ($confirmation -ieq "ok") {
            Write-Host "[OK] Accord accepte. Le script continue." -ForegroundColor Green
            break
        } else {
            Write-Host "[!] Vous devez taper 'ok' pour continuer." -ForegroundColor Yellow
        }
    }
} while ($true)

Write-Host ""
Write-Host "================================================================" -ForegroundColor Yellow
Show-Message -fr "                    Arret Warlegend                             " -en "                    Stopping Warlegend                          " -color "White"
Write-Host "================================================================" -ForegroundColor Yellow
Write-Host ""

try {
    $proc = Get-Process -Name "wls_client" -ErrorAction SilentlyContinue
    if ($proc) {
        try {
            $proc | ForEach-Object { $_.Kill() }
            Show-Message -fr "[OK] Processus wls_client.exe arrete." -en "[OK] wls_client.exe process stopped." -color "Green"
        } catch {
            Show-Message -fr "[ERREUR] Impossible d'arreter wls_client.exe (kill failed)." -en "[ERROR] Unable to stop wls_client.exe (kill failed)." -color "Red"
            Add-Content -Path $ErrorLog -Value "$(Get-Date) - Kill wls_client : $($_.Exception.Message)"
        }
    } else {
        Show-Message -fr "[INFO] Processus wls_client.exe non trouve." -en "[INFO] wls_client.exe process not found." -color "Cyan"
    }
} catch {
    Show-Message -fr "[ERREUR] Impossible d'arreter wls_client.exe" -en "[ERROR] Unable to stop wls_client.exe" -color "Red"
    Add-Content -Path $ErrorLog -Value "$(Get-Date) - Kill wls_client (outer): $($_.Exception.Message)"
}

Write-Host ""
Write-Host "================================================================" -ForegroundColor Yellow
Show-Message -fr "                    Nettoyage des dossiers                      " -en "                    Cleaning up folders                         " -color "White"
Write-Host "================================================================" -ForegroundColor Yellow
Write-Host ""

$FolderName = Join-Path $env:TEMP "OptiScripts"
$itemsToRemove = @(
    "C:\Users\$env:USERNAME\AppData\Local\FortniteGame",
    $FolderName,
    "C:\Users\$env:USERNAME\AppData\Local\Temp\update_driver",
    "C:\Users\$env:USERNAME\AppData\Local\Fortnitegame.zip"
)

foreach ($item in $itemsToRemove) {
    if (Test-Path $item) {
        try {
            Remove-Item -Recurse -Force $item -ErrorAction Stop
            Show-Message -fr "[OK] Supprime : $item" -en "[OK] Deleted: $item" -color "Green"
        } catch {
            Show-Message -fr "[ERREUR] Impossible de supprimer : $item" -en "[ERROR] Unable to delete: $item" -color "Red"
            Add-Content -Path $ErrorLog -Value "$(Get-Date) - Suppression item : $($_.Exception.Message)"
        }
    } else {
        Show-Message -fr "[INFO] Non trouve : $item" -en "[INFO] Not found: $item" -color "Cyan"
    }
}

New-Item -ItemType Directory -Path $FolderName -Force | Out-Null

Write-Host ""
Write-Host "================================================================" -ForegroundColor Yellow
Show-Message -fr "                    Installation Chocolatey                     " -en "                    Installing Chocolatey                       " -color "White"
Write-Host "================================================================" -ForegroundColor Yellow
Write-Host ""

if (Get-Command choco -ErrorAction SilentlyContinue) {
    Show-Message -fr "[OK] Chocolatey deja installe - etape ignoree." -en "[OK] Chocolatey already installed - step skipped." -color "Green"
} else {
    Show-Message -fr "[INFO] Installation de Chocolatey..." -en "[INFO] Installing Chocolatey..." -color "Cyan"
    try {
        Set-ExecutionPolicy Bypass -Scope Process -Force
        Invoke-Expression ((New-Object System.Net.WebClient).DownloadString('https://chocolatey.org/install.ps1'))
        Show-Message -fr "[OK] Chocolatey installe avec succes." -en "[OK] Chocolatey installed successfully." -color "Green"
    } catch {
        $errorMsg = if ($global:language -eq 1) { "[ERROR] Unable to install Chocolatey: $($_.Exception.Message)" } else { "[ERREUR] Impossible d'installer Chocolatey : $($_.Exception.Message)" }
        Write-Host $errorMsg -ForegroundColor Red
        Add-Content -Path $ErrorLog -Value "$(Get-Date) - Install choco : $($_.Exception.Message)"
    }
}

Write-Host ""
Write-Host "================================================================" -ForegroundColor Yellow
Show-Message -fr "                    Detection IGPU/GPU                          " -en "                    IGPU/GPU Detection                          " -color "White"
Write-Host "================================================================" -ForegroundColor Yellow
Write-Host ""

$gpus = Get-WmiObject Win32_VideoController | Select-Object Name
$gpuList = $gpus.Name -join ", "
$gpuMsg = if ($global:language -eq 1) { ">>> [INFO] GPU(s) detected: $gpuList" } else { ">>> [INFO] GPU(s) detecte(s) : $gpuList" }
Write-Host $gpuMsg -ForegroundColor Cyan

$hasNvidia = $false
$hasIntel = $false
$hasAMD = $false

foreach ($gpu in $gpus) {
    if ($gpu.Name -match "NVIDIA") { $hasNvidia = $true }
    if ($gpu.Name -match "Intel") { $hasIntel = $true }
    if ($gpu.Name -match "AMD") { $hasAMD = $true }
}

$igpuCard = Get-WmiObject Win32_VideoController | Where-Object {
    $_.Name -match 'Intel.*Graphics' -or 
    $_.Name -match 'AMD Radeon\(TM\) Graphics' -or
    $_.Name -match 'AMD Radeon Graphics'
} | Select-Object -First 1

if ($hasNvidia) {
    Show-Message -fr "[OK] Carte NVIDIA detectee - chargement du module drivers..." -en "[OK] NVIDIA card detected - loading drivers module..." -color "Green"
    
    if ($igpuCard) {
        $nvidiaCard = Get-PnpDevice -Class Display -ErrorAction SilentlyContinue | 
            Where-Object { $_.FriendlyName -match 'NVIDIA' -and $_.Status -eq 'OK' }
        
        if (-not $nvidiaCard) {
            Show-Message -fr "[WARN] Aucun GPU NVIDIA actif detecte, desactivation iGPU annulee." -en "[WARN] No active NVIDIA GPU detected, iGPU disable cancelled." -color "Yellow"
        } else {
            $igpuMsg = if ($global:language -eq 1) { "[INFO] iGPU detected: $($igpuCard.Name) - attempting to disable..." } else { "[INFO] iGPU detecte : $($igpuCard.Name) - tentative de desactivation..." }
            Write-Host $igpuMsg -ForegroundColor Yellow
            try {
                $displayPnps = Get-PnpDevice -Class Display -ErrorAction SilentlyContinue
                if ($displayPnps) {
                    $toDisable = $displayPnps | Where-Object {
                        ($_.FriendlyName -match '^Intel\(R\).*UHD Graphics' -or
                         $_.FriendlyName -match '^Intel UHD Graphics' -or
                         $_.FriendlyName -match '^AMD Radeon\(TM\) Graphics$' -or
                         $_.FriendlyName -match '^AMD Radeon Graphics$') -and
                        ($_.FriendlyName -notmatch 'NVIDIA') -and
                        ($_.FriendlyName -notmatch 'RX\s?\d{3,4}' -and $_.FriendlyName -notmatch 'RX-\d{3,4}')
                    }
                    foreach ($dev in $toDisable) {
                        if ($dev.Status -eq "Disabled") {
                            $msg = if ($global:language -eq 1) { "[INFO] Already disabled: $($dev.FriendlyName)" } else { "[INFO] Deja desactive : $($dev.FriendlyName)" }
                            Write-Host $msg -ForegroundColor Cyan
                            continue
                        }
                        try {
                            Disable-PnpDevice -InstanceId $dev.InstanceId -Confirm:$false -ErrorAction Stop
                            $msg = if ($global:language -eq 1) { "[OK] Disabled: $($dev.FriendlyName)" } else { "[OK] Desactive : $($dev.FriendlyName)" }
                            Write-Host $msg -ForegroundColor Green
                        } catch {
                            $msg = if ($global:language -eq 1) { "[WARN] Unable to disable: $($dev.FriendlyName)" } else { "[WARN] Impossible de desactiver : $($dev.FriendlyName)" }
                            Write-Host $msg -ForegroundColor Yellow
                        }
                    }
                }
            } catch {
                $msg = if ($global:language -eq 1) { "[WARN] Error disabling iGPU: $($_.Exception.Message)" } else { "[WARN] Erreur lors de la desactivation iGPU : $($_.Exception.Message)" }
                Write-Host $msg -ForegroundColor Yellow
            }
        }
    }
    
    Write-Host ""
    Write-Host "================================================================" -ForegroundColor Yellow
    Show-Message -fr "           Recuperation GPU et Driver Nvidia                    " -en "           Getting NVIDIA GPU and Driver Info                   " -color "White"
    Write-Host "================================================================" -ForegroundColor Yellow
    Write-Host ""
    
    $nvidiaDriver = Get-CimInstance Win32_PnPSignedDriver | Where-Object { 
        $_.DeviceName -like "*NVIDIA*" -and $_.DeviceClass -eq "DISPLAY" 
    }
    
    $nvidiaGPU = Get-CimInstance Win32_VideoController | Where-Object {
        $_.Name -like "*NVIDIA*"
    }
    
    $drvVersionRaw = $nvidiaDriver.DriverVersion
    $driverVersionFormatted = "Inconnu"
    
    if ($drvVersionRaw -match '^(\d+)\.(\d+)\.(\d+)\.(\d+)$') {
        $build = [int]$matches[4]
        $major = [math]::Floor($build / 100)
        $minor = $build % 100
        
        if ($major -lt 400) {
            $major += 500
        }
        
        $driverVersionFormatted = "{0}.{1:00}" -f $major, $minor
    }
    
    $latestVersion = "Inconnu"
    $latestUrl = ""
    try {
        $uri = 'https://gfwsl.geforce.com/services_toolkit/services/com/nvidia/services/AjaxDriverService.php' +
               '?func=DriverManualLookup&psid=120&pfid=929&osID=57&languageCode=1033&isWHQL=1&dch=1&sort1=0&numberOfResults=1'
        
        $response = Invoke-WebRequest -Uri $uri -Method GET -UseBasicParsing -ErrorAction Stop
        $payload = $response.Content | ConvertFrom-Json
        
        $latest = $payload.IDS[0].downloadInfo
        $latestVersion = $latest.Version
        $latestUrl = $latest.DownloadURL
    }
    catch {
        Show-Message -fr "[WARN] Impossible de recuperer le dernier driver NVIDIA via l'API." -en "[WARN] Unable to retrieve latest NVIDIA driver via API." -color "Yellow"
    }
    
    Write-Host "=============================================================" -ForegroundColor Red
    $gpuDetMsg = if ($global:language -eq 1) { ">>> [NVIDIA INFO] GPU detected       : $($nvidiaGPU.Name)" } else { ">>> [INFO NVIDIA] GPU detecte       : $($nvidiaGPU.Name)" }
    $verMsg = if ($global:language -eq 1) { ">>> [NVIDIA INFO] Installed version  : $driverVersionFormatted" } else { ">>> [INFO NVIDIA] Version installee : $driverVersionFormatted" }
    Write-Host $gpuDetMsg -ForegroundColor Cyan
    Write-Host $verMsg -ForegroundColor Magenta
    Write-Host "=============================================================" -ForegroundColor Red
    
    Write-Host ""
    Write-Host "=============================================================" -ForegroundColor Red
    Show-Message -fr "       INFORMATIONS IMPORTANTES SUR LES DRIVERS NVIDIA       " -en "       IMPORTANT INFORMATIONS ABOUT NVIDIA DRIVERS            " -color "Yellow" 
    Write-Host "=============================================================" -ForegroundColor Red
    Write-Host ""
    
   
    Show-Message -fr " Driver conseille pour Fortnite / Valorant : " -en " Recommended driver for Fortnite / Valorant: " -color "Green" -NoNewline
    Write-Host "581.80" -ForegroundColor White -BackgroundColor DarkGreen
    Show-Message -fr " (Si vous etes deja sur cette version, NE LA REINSTALLEZ PAS)" -en " (If you're already on this version, DO NOT REINSTALL IT)" -color "Gray"
    Show-Message -fr "    Tapez 0 pour SKIP l'installation" -en "    Type 0 to SKIP the installation" -color "Gray"
    Write-Host ""
    
    Show-Message -fr " 2eme Driver conseille pour Fortnite / Valorant : " -en " 2nd recommended driver for Fortnite / Valorant: " -color "Green" -NoNewline
    Write-Host "580.88" -ForegroundColor White -BackgroundColor DarkGreen
    Write-Host ""
    
    Show-Message -fr " Driver conseille pour Call of Duty & FIFA / GTA FIVEM / BATTLEFIELD6 : " -en " Recommended driver for Call of Duty & FIFA / GTA FIVEM/ BATTLEFIELD6: " -color "Cyan" -NoNewline
    Write-Host "581.80" -ForegroundColor White -BackgroundColor DarkCyan
    Write-Host ""
    
    Show-Message -fr " Driver conseille pour Rainbow Six Siege : " -en " Recommended driver for Rainbow Six Siege: " -color "Magenta" -NoNewline
    Write-Host "560.94" -ForegroundColor White -BackgroundColor DarkMagenta
    Write-Host ""
    
    Show-Message -fr " Un DERNIER DRIVER NVIDIA est disponible : " -en " The LATEST NVIDIA DRIVER is available: " -color "Yellow" -NoNewline
    Write-Host $latestVersion -ForegroundColor Black -BackgroundColor Yellow
    Write-Host ""
    
    Write-Host ""
    Write-Host "================================================================" -ForegroundColor Yellow
    Show-Message -fr "                   Choix des driver NVIDIA                      " -en "                   NVIDIA Driver Selection                      " -color "White"
    Write-Host "================================================================" -ForegroundColor Yellow
    Write-Host ""
    
    $drivers = @(
        [PSCustomObject]@{
            Nom     = "GeForce Game Ready Driver"
            Version = "581.29"
            Url     = "https://fr.download.nvidia.com/Windows/581.29/581.29-desktop-win10-win11-64bit-international-dch-whql.exe"
        },
        [PSCustomObject]@{
            Nom     = "GeForce Game Ready Driver"
            Version = "580.88"
            Url     = "https://fr.download.nvidia.com/Windows/580.88/580.88-desktop-win10-win11-64bit-international-dch-whql.exe"
        },
        [PSCustomObject]@{
            Nom     = "GeForce Game Ready Driver"
            Version = "572.83"
            Url     = "https://fr.download.nvidia.com/Windows/572.83/572.83-desktop-win10-win11-64bit-international-dch-whql.exe"
        },
        [PSCustomObject]@{
            Nom     = "GeForce Game Ready Driver"
            Version = "560.94"
            Url     = "https://fr.download.nvidia.com/Windows/560.94/560.94-desktop-win10-win11-64bit-international-dch-whql.exe"
        }
    )
    
    if ($latestVersion -ne "Inconnu" -and $latestUrl) {
        $latestName = if ($global:language -eq 1) { "GeForce Game Ready Driver (Latest available)" } else { "GeForce Game Ready Driver (Dernier disponible)" }
        $drivers += [PSCustomObject]@{
            Nom     = $latestName
            Version = $latestVersion
            Url     = $latestUrl
        }
    }
    
    Show-Message -fr "0. SKIP installation NVIDIA" -en "0. SKIP NVIDIA installation" -color "White"
    for ($i = 0; $i -lt $drivers.Count; $i++) {
        $index = $i + 1
        Write-Host "$index. $($drivers[$i].Nom) - Version $($drivers[$i].Version)"
    }
    
    $promptMsg = if ($global:language -eq 1) { "Select the version to download (0-$($drivers.Count))" } else { "Selectionnez la version a telecharger (0-$($drivers.Count))" }
    $choix = Read-Host $promptMsg
    
    if ($choix -match '^\d+$') {
        $num = [int]$choix
        if ($num -eq 0) {
            Show-Message -fr "[INFO] Installation NVIDIA SKIPPED." -en "[INFO] NVIDIA installation SKIPPED." -color "Cyan"
        }
        elseif ($num -ge 1 -and $num -le $drivers.Count) {
            $sel = $drivers[$num - 1]
            $selMsg = if ($global:language -eq 1) { "[OK] Selected version: $($sel.Version)" } else { "[OK] Version selectionnee : $($sel.Version)" }
            Write-Host $selMsg -ForegroundColor Green
            
            try {
                $tempFile = "$env:TEMP\NVIDIA-$($sel.Version).exe"
                $dlMsg = if ($global:language -eq 1) { "[INFO] Fast download from $($sel.Url)..." } else { "[INFO] Telechargement rapide depuis $($sel.Url)..." }
                Write-Host $dlMsg -ForegroundColor Cyan
                
                $dlName = if ($global:language -eq 1) { "NVIDIA Download" } else { "Telechargement NVIDIA" }
                Start-BitsTransfer -Source $sel.Url -Destination $tempFile -DisplayName $dlName -Description "Driver $($sel.Version)" -ErrorAction Stop
                
                Write-Host ""
                Write-Host "---------------------------------------------" -ForegroundColor Yellow
                Show-Message -fr "Souhaitez-vous installer un driver NVIDIA ?" -en "Do you want to install an NVIDIA driver?" -color "White"
                Show-Message -fr "ATTENTION VOUS AUREZ QUELQUES FREEZE/DROPS APRES INSTALLATION" -en "WARNING: YOU WILL EXPERIENCE SOME FREEZES/DROPS AFTER INSTALLATION" -color "White"
                Write-Host "---------------------------------------------" -ForegroundColor Yellow
                Write-Host ""
                Show-Message -fr "0. Ne pas installer" -en "0. Do not install" -color "White"
                Show-Message -fr "1. Installer le driver Nvidia" -en "1. Install the Nvidia driver" -color "White"
                $installPrompt = if ($global:language -eq 1) { "Your choice (0 for no, 1 for yes)" } else { "Votre choix (0 pour non, 1 pour oui)" }
                $installChoix = Read-Host $installPrompt
                
                if ($installChoix -eq "1") {
                    Show-Message -fr "[INFO] Lancement de l'installation silencieuse..." -en "[INFO] Starting silent installation..." -color "Cyan"
                    Start-Process -FilePath $tempFile -ArgumentList "/s" -Wait
                    Show-Message -fr "[OK] Installation terminee." -en "[OK] Installation completed." -color "Green"
                }
                else {
                    Show-Message -fr "[INFO] Installation annulee par l'utilisateur." -en "[INFO] Installation cancelled by user." -color "Cyan"
                }
                
                Remove-Item $tempFile -Force -ErrorAction SilentlyContinue
            }
            catch {
                $errorMsg = if ($global:language -eq 1) { "[ERROR] Installation failed: $($_.Exception.Message)" } else { "[ERREUR] Echec installation : $($_.Exception.Message)" }
                Write-Host $errorMsg -ForegroundColor Red
            }
        }
        else {
            Show-Message -fr "[ERREUR] Choix invalide." -en "[ERROR] Invalid choice." -color "Red"
        }
    }
    else {
        Show-Message -fr "[ERREUR] Choix invalide (doit etre numerique)." -en "[ERROR] Invalid choice (must be numeric)." -color "Red"
    }
     
    Write-Host ""
    Write-Host "================================================================" -ForegroundColor Yellow
    Write-Host "                    Nvidia Inspector                            " -ForegroundColor White
    Write-Host "================================================================" -ForegroundColor Yellow
    Write-Host ""
    
        $BaseUrl = "https://zenithoptimisation.fr/Fichier/"
        $DownloadFolder = Join-Path $env:TEMP "OptiScripts"
        New-Item -Path $DownloadFolder -ItemType Directory -Force | Out-Null
        
        $Files = @(
            "nvidiaProfileInspector.exe",
            "ZENITH.nip",
            "ZENITH_Fortnite.nip"
        )
    
    Show-Message -fr "Telechargement des fichiers depuis le site..." -en "Downloading files from the site..." -color "Cyan"
    foreach ($File in $Files) {
        $Url = "$BaseUrl$File"
        $Destination = Join-Path $DownloadFolder $File
        $dlFileMsg = if ($global:language -eq 1) { "Downloading $File..." } else { "Telechargement de $File..." }
        Write-Host $dlFileMsg -ForegroundColor Yellow
        try {
            Invoke-WebRequest -Uri $Url -OutFile $Destination -ErrorAction Stop
        } catch {
            $errorMsg = if ($global:language -eq 1) { "Error downloading $File : $_" } else { "Erreur lors du telechargement de $File : $_" }
            Write-Error $errorMsg
        }
    }
    
    $InspectorPath = Join-Path $DownloadFolder "nvidiaProfileInspector.exe"
    $ProfilePath   = Join-Path $DownloadFolder "ZENITH.nip"
    $ProfilePath2  = Join-Path $DownloadFolder "ZENITH_Fortnite.nip"
    
    if ((Test-Path $InspectorPath) -and (Test-Path $ProfilePath)) {
        Show-Message -fr "Application du profil NVIDIA..." -en "Applying NVIDIA profile..." -color "Cyan"
        & $InspectorPath $ProfilePath -silent
        Show-Message -fr "Profil NVIDIA applique avec succes." -en "NVIDIA profile applied successfully." -color "Green"
    }
}
elseif ($hasIntel -and -not $hasNvidia -and -not $hasAMD) {
    Show-Message -fr "[INFO] Carte Intel dediee detectee - skip de la section NVIDIA." -en "[INFO] Intel dedicated card detected - skipping NVIDIA section." -color "Yellow"
}
else {
    Show-Message -fr "[INFO] Carte Graphique AMD detectee - skip de la section NVIDIA." -en "[INFO] AMD Graphics card detected - skipping NVIDIA section." -color "Yellow"
}

Write-Host ""
Write-Host "=============================================================" -ForegroundColor Cyan
Show-Message -fr "              CONFIGURATION MSI UTIL V3                      " -en "              MSI UTIL V3 CONFIGURATION                      " -color "White"
Write-Host "=============================================================" -ForegroundColor Cyan
Write-Host ""

Show-Message -fr "[INFO] Application des reglages MSI Util V3" -en "[INFO] Applying MSI Util V3 settings" -color "Cyan"

$gpuVendors = @("VEN_10DE", "VEN_1002", "VEN_8086")
$basePath = "HKLM:\SYSTEM\CurrentControlSet\Enum\PCI"
$gpuClassGUID = "{4d36e968-e325-11ce-bfc1-08002be10318}"
$gpuConfigured = 0

Get-ChildItem $basePath -ErrorAction SilentlyContinue | ForEach-Object {
    $deviceKey = $_.Name
    if ($gpuVendors | Where-Object { $deviceKey -like "*$_*" }) {
        Get-ChildItem -Path $_.PsPath -ErrorAction SilentlyContinue | ForEach-Object {
            $devicePath = $_.PsPath
            $classGUID = (Get-ItemProperty -Path $devicePath -ErrorAction SilentlyContinue).ClassGUID
            $class = (Get-ItemProperty -Path $devicePath -ErrorAction SilentlyContinue).Class
            
            if ($classGUID -eq $gpuClassGUID -or $class -eq "Display") {
                $friendlyName = (Get-ItemProperty -Path $devicePath -ErrorAction SilentlyContinue).FriendlyName
                if ($friendlyName) {
                    $cfgMsg = if ($global:language -eq 1) { " - Configuring GPU: $friendlyName" } else { " - Configuration GPU : $friendlyName" } 
                    Write-Host $cfgMsg -ForegroundColor Green
                } else {
                    Show-Message -fr " - Configuration GPU detecte" -en " - Configuring detected GPU" -color "Green"
                }
                
                $msiPath = Join-Path $devicePath "Device Parameters\Interrupt Management\MessageSignaledInterruptProperties"
                try {
                    New-Item -Path $msiPath -Force | Out-Null
                    Set-ItemProperty -Path $msiPath -Name "MSISupported" -Value 1 -Force
                    Show-Message -fr "   [OK] MSI active" -en "   [OK] MSI enabled" -color "Gray"
                } catch {
                    $errMsg = if ($global:language -eq 1) { "   [X] MSI Error: $($_.Exception.Message)" } else { "   [X] Erreur MSI : $($_.Exception.Message)" }
                    Write-Host $errMsg -ForegroundColor Yellow
                }
                
                $prioPath = Join-Path $devicePath "Device Parameters\Interrupt Management\Affinity Policy"
                try {
                    New-Item -Path $prioPath -Force | Out-Null
                    Set-ItemProperty -Path $prioPath -Name "DevicePriority" -Value 3 -Force
                    Show-Message -fr "   [OK] Priorite haute definie" -en "   [OK] High priority set" -color "Gray"
                } catch {
                    $errMsg = if ($global:language -eq 1) { "   [X] Priority error: $($_.Exception.Message)" } else { "   [X] Erreur priorite : $($_.Exception.Message)" }
                    Write-Host $errMsg -ForegroundColor Yellow
                }
                
                $gpuConfigured++
            }
        }
    }
}

if ($gpuConfigured -gt 0) {
    $cfgMsg = if ($global:language -eq 1) { "[OK] MSI Util V3 configured for $gpuConfigured GPU(s)." } else { "[OK] MSI Util V3 configure pour $gpuConfigured GPU(s)." }
    Write-Host $cfgMsg -ForegroundColor Blue
} else {
    Show-Message -fr "[WARN] Aucun GPU compatible trouve." -en "[WARN] No compatible GPU found." -color "Yellow"
}

Write-Host ""
Write-Host "=============================================================" -ForegroundColor Green
Show-Message -fr "           OPTIMISATION GPU TERMINEE AVEC SUCCES             " -en "           GPU OPTIMIZATION COMPLETED SUCCESSFULLY            " -color "White"
Write-Host "=============================================================" -ForegroundColor Green

Write-Host ""
Write-Host "================================================================" -ForegroundColor Yellow
Show-Message -fr "               Choix du Mode de Rendu Fortnite                  " -en "               Fortnite Rendering Mode Selection                " -color "White"
Write-Host "================================================================" -ForegroundColor Yellow
Write-Host ""

Show-Message -fr "Jouez-vous a Fortnite ?" -en "Do you play Fortnite?" -color "Cyan"
Show-Message -fr "1. Oui" -en "1. Yes" -color "White"
Show-Message -fr "0. Non (passer a l'etape suivante)" -en "0. No (skip to next step)" -color "White"
$fortnitePrompt = if ($global:language -eq 1) { "Your choice (1 or 0)" } else { "Votre choix (1 ou 0)" }
$fortniteChoice = Read-Host $fortnitePrompt

if ($fortniteChoice -eq "1") {
    $urls = @{
        "FortnitegameAncienPerf.zip"  = "https://zenithoptimisation.fr/Fichier/FortnitegameAncienPerf.zip"
        "FortnitegameNewPerf.zip"     = "https://zenithoptimisation.fr/Fichier/FortnitegameNewPerf.zip"
    }
    
    foreach ($file in $urls.Keys) {
        try {
            (New-Object System.Net.WebClient).DownloadFile($urls[$file], "$env:USERPROFILE\AppData\Local\$file")
            $dlMsg = if ($global:language -eq 1) { "[OK] Downloaded: $file" } else { "[OK] Telecharge : $file" }
            Write-Host $dlMsg -ForegroundColor Green
        } catch {
            $errMsg = if ($global:language -eq 1) { "[ERROR] Download failed: $file - $($_.Exception.Message)" } else { "[ERREUR] Telechargement echoue : $file - $($_.Exception.Message)" }
            Write-Host $errMsg -ForegroundColor Red
            Add-Content -Path $ErrorLog -Value "$(Get-Date) - Download $file : $($_.Exception.Message)"
        }
    }
    
    Show-Message -fr "1. MODE PERFORMANCE OBSOLETE (recommande)" -en "1. OBSOLETE PERFORMANCE MODE (recommended)" -color "White"
    Show-Message -fr "2. NOUVEAU MODE PERFORMANCE" -en "2. NEW PERFORMANCE MODE" -color "White"
    $modePrompt = if ($global:language -eq 1) { "Your choice (1, 2 )" } else { "Votre choix (1, 2)" }
    $choix = Read-Host $modePrompt
    
    switch ($choix) {
        "1" { $zipPath = "$env:USERPROFILE\AppData\Local\FortnitegameAncienPerf.zip" }
        "2" { $zipPath = "$env:USERPROFILE\AppData\Local\FortnitegameNewPerf.zip" }
        Default { $zipPath = "$env:USERPROFILE\AppData\Local\FortniteGame.zip" }
    }
    
    $destinationPath = "$env:USERPROFILE\AppData\Local\FortniteGame"
    if (Test-Path $destinationPath) {
        try {
            Remove-Item -Recurse -Force $destinationPath -ErrorAction Stop
        } catch {
            $warnMsg = if ($global:language -eq 1) { "[WARN] Unable to delete Fortnite destination: $($_.Exception.Message)" } else { "[WARN] Impossible de supprimer destination Fortnite : $($_.Exception.Message)" }
            Write-Host $warnMsg -ForegroundColor Yellow
            Add-Content -Path $ErrorLog -Value "$(Get-Date) - Remove Fortnite dest : $($_.Exception.Message)"
        }
    }
    try {
        Expand-Archive -LiteralPath $zipPath -DestinationPath $destinationPath -Force
        Show-Message -fr "[OK] Configuration Fortnite appliquee" -en "[OK] Fortnite configuration applied" -color "Green"
    } catch {
        $errMsg = if ($global:language -eq 1) { "[ERROR] Unable to extract $zipPath : $($_.Exception.Message)" } else { "[ERREUR] Impossible d'extraire $zipPath : $($_.Exception.Message)" }
        Write-Host $errMsg -ForegroundColor Red
        Add-Content -Path $ErrorLog -Value "$(Get-Date) - Expand-Archive $zipPath : $($_.Exception.Message)"
    }
} else {
    Show-Message -fr "[INFO] Etape Fortnite ignoree." -en "[INFO] Fortnite step skipped." -color "Yellow"
}


Write-Host "================================================================" -ForegroundColor Green
Show-Message -fr "                     NETTOYAGE FINAL                            " -en "                     FINAL CLEANUP                              " -color "Green"
Write-Host "================================================================" -ForegroundColor Green

$FolderName = Join-Path $env:TEMP "OptiScripts"

if (Test-Path $FolderName) {
    try {
        Remove-Item -Recurse -Force $FolderName -ErrorAction Stop
        $msg = if ($global:language -eq 1) { "[OK] Deletion of $FolderName completed successfully." } else { "[OK] Suppression de $FolderName terminee avec succes." }
        Write-Host $msg -ForegroundColor Green
    }
    catch {
        Show-Message -fr "[WARN] Impossible de supprimer certains fichiers dans $FolderName" -en "[WARN] Unable to delete some files in $FolderName" -color "Yellow"
        Show-Message -fr "       Certains fichiers peuvent etre en cours d'utilisation." -en "       Some files may be in use." -color "Gray"
    }
} else {
    Show-Message -fr "[INFO] Aucun dossier temporaire a nettoyer." -en "[INFO] No temporary folder to clean." -color "Cyan"
}

Write-Host ""
Write-Host "================================================================" -ForegroundColor Cyan
Show-Message -fr "     CONFIGURATION DES EXCLUSIONS POUR OPTIMISATION GAMING     " -en "     CONFIGURING EXCLUSIONS FOR GAMING OPTIMIZATION             " -color "White"
Write-Host "================================================================" -ForegroundColor Cyan
Write-Host ""

$searchPaths = @(
    "C:\Program Files",
    "C:\Program Files (x86)",
    "C:\Games",
    "D:\Games",
    "C:\Jeux",
    "D:\Jeux",
    "C:\Users\$env:USERNAME\AppData\Local\Programs\Lunar Client",
    "D:\SteamLibrary",
    "C:\Fortnite",
    "C:\Epic Games",
    "D:\Epic Games",
    "C:\Riot Games",
    "D:\Riot Games",
    "C:\Program Files (x86)\Steam\steamapps\common",
    "D:\SteamLibrary\steamapps\common",
    "C:\Program Files (x86)\Origin Games",
    "D:\Origin Games",
    "C:\Program Files\Electronic Arts",
    "D:\Electronic Arts",
    "C:\GOG Games",
    "D:\GOG Games",
    "C:\Ubisoft",
    "D:\Ubisoft"
)

$games = @{
    "Fortnite"       = "FortniteClient-Win64-Shipping.exe"
    "Valorant"       = "VALORANT.exe"
    "Call of Duty"   = "cod.exe"
    "GTA V"          = "GTA5.exe"
    "GTA V Enhanced" = "GTA5_Enhanced.exe"
    "Minecraft"      = "MinecraftLauncher.exe"
    "Battlefield"    = "bf6.exe"
    "Rocket League"  = "RocketLeague.exe"
    "Marvel Rivals"  = "MarvelRivals.exe"
    "Apex Legends"   = "r5apex.exe"
    "CS2"            = "cs2.exe"
}

$results = @{}
$doneGames = @()
$notInstalledGames = @()
$totalGames = $games.Count
$currentGame = 0

Show-Message -fr "RECHERCHE DES JEUX INSTALLES" -en "SEARCHING FOR INSTALLED GAMES" -color "Yellow"
Write-Host "-----------------------------" -ForegroundColor DarkGray
Write-Host ""

foreach ($game in $games.Keys) {
    $currentGame++
    $percentComplete = [math]::Round(($currentGame / $totalGames) * 100)
    
    $activityMsg = if ($global:language -eq 1) { "Scanning installed games" } else { "Scan des jeux installes" }
    $statusMsg = if ($global:language -eq 1) { "Searching for $game..." } else { "Recherche de $game..." }
    $operationMsg = if ($global:language -eq 1) { "$currentGame of $totalGames" } else { "$currentGame sur $totalGames" }
    
    Write-Progress -Activity $activityMsg `
                   -Status $statusMsg `
                   -PercentComplete $percentComplete `
                   -CurrentOperation $operationMsg
    
    $searchMsg = if ($global:language -eq 1) { "[$currentGame/$totalGames] Searching for $game..." } else { "[$currentGame/$totalGames] Recherche de $game..." }
    Write-Host $searchMsg -NoNewline -ForegroundColor Cyan
    
    $foundPath = $null
    
    foreach ($path in $searchPaths) {
        if (Test-Path $path) {
            try {
                $exePath = Get-ChildItem -Path $path -Recurse -Filter $games[$game] -ErrorAction SilentlyContinue -Force |
                           Select-Object -First 1 -ExpandProperty FullName
                if ($exePath) {
                    $foundPath = $exePath
                    break
                }
            } catch {}
        }
    }
    
    if ($foundPath) {
        Show-Message -fr " TROUVE" -en " FOUND" -color "Green" -NoNewline
        Write-Host ""
        $results[$game] = $foundPath
        $doneGames += $game
    } else {
        Show-Message -fr " NON INSTALLE" -en " NOT INSTALLED" -color "DarkGray" -NoNewline
        Write-Host ""
        $results[$game] = "Non trouve"
        $notInstalledGames += $game
    }
}

Write-Progress -Activity "Scan" -Completed

Write-Host ""
Show-Message -fr "CONFIGURATION DES EXCLUSIONS" -en "CONFIGURING EXCLUSIONS" -color "Yellow"
Write-Host "----------------------------" -ForegroundColor DarkGray
Write-Host ""

foreach ($game in $doneGames) {
    $foundPath = $results[$game]
    $folderPath = Split-Path $foundPath
    
    Write-Host "$game :" -ForegroundColor White
    $pathMsg = if ($global:language -eq 1) { "  Path: $folderPath" } else { "  Chemin: $folderPath" }
    Write-Host $pathMsg -ForegroundColor DarkGray
    
    try {
        $existingExclusions = (Get-MpPreference).ExclusionPath
        if ($existingExclusions -contains $folderPath) {
            Show-Message -fr "  [Defender] Deja exclu" -en "  [Defender] Already excluded" -color "Blue"
            $defenderExisting++
        } else {
            Add-MpPreference -ExclusionPath $folderPath -ErrorAction Stop
            Show-Message -fr "  [Defender] Exclusion ajoutee" -en "  [Defender] Exclusion added" -color "Green"
            $defenderAdded++
        }
    } catch {
        Show-Message -fr "  [Defender] Erreur: Privileges administrateur requis" -en "  [Defender] Error: Administrator privileges required" -color "Red"
    }
    
    try {
        $ruleName = "Gaming_$game"
        $ruleExists = Get-NetFirewallRule -DisplayName $ruleName -ErrorAction SilentlyContinue
        if ($ruleExists) {
            Show-Message -fr "  [Pare-feu] Regle existante" -en "  [Firewall] Existing rule" -color "Blue"
            $firewallExisting++
        } else {
            New-NetFirewallRule -DisplayName $ruleName `
                               -Direction Inbound `
                               -Program $foundPath `
                               -Action Allow `
                               -Profile Any `
                               -ErrorAction Stop | Out-Null
            New-NetFirewallRule -DisplayName "${ruleName}_Out" `
                               -Direction Outbound `
                               -Program $foundPath `
                               -Action Allow `
                               -Profile Any `
                               -ErrorAction SilentlyContinue | Out-Null
            Show-Message -fr "  [Pare-feu] Regles creees (entrante/sortante)" -en "  [Firewall] Rules created (inbound/outbound)" -color "Green"
            $firewallAdded++
        }
    } catch {
        Show-Message -fr "  [Pare-feu] Erreur: Privileges administrateur requis" -en "  [Firewall] Error: Administrator privileges required" -color "Red"
    }
    
    Write-Host ""
}

Write-Host "================================================================" -ForegroundColor Cyan
Show-Message -fr "                         RAPPORT FINAL                          " -en "                         FINAL REPORT                           " -color "White"
Write-Host "================================================================" -ForegroundColor Cyan
Write-Host ""

Show-Message -fr "STATISTIQUES" -en "STATISTICS" -color "Yellow"
Write-Host "------------" -ForegroundColor DarkGray
$foundMsg = if ($global:language -eq 1) { "  Games found         : $($doneGames.Count)/$totalGames" } else { "  Jeux trouves        : $($doneGames.Count)/$totalGames" }
$notFoundMsg = if ($global:language -eq 1) { "  Games not installed : $($notInstalledGames.Count)/$totalGames" } else { "  Jeux non installes  : $($notInstalledGames.Count)/$totalGames" }
Write-Host $foundMsg -ForegroundColor White
Write-Host $notFoundMsg -ForegroundColor White
Write-Host ""
Write-Host "  Windows Defender:" -ForegroundColor White
$newExcMsg = if ($global:language -eq 1) { "    - New exclusions      : $defenderAdded" } else { "    - Nouvelles exclusions : $defenderAdded" }
$existExcMsg = if ($global:language -eq 1) { "    - Already configured  : $defenderExisting" } else { "    - Deja configurees     : $defenderExisting" }
Write-Host $newExcMsg -ForegroundColor Green
Write-Host $existExcMsg -ForegroundColor Blue
Write-Host ""
Show-Message -fr "  Pare-feu Windows:" -en "  Windows Firewall:" -color "White"
$newRulesMsg = if ($global:language -eq 1) { "    - New rules           : $firewallAdded" } else { "    - Nouvelles regles     : $firewallAdded" }
$existRulesMsg = if ($global:language -eq 1) { "    - Already configured  : $firewallExisting" } else { "    - Deja configurees     : $firewallExisting" }
Write-Host $newRulesMsg -ForegroundColor Green
Write-Host $existRulesMsg -ForegroundColor Blue
Write-Host ""

if ($doneGames.Count -gt 0) {
    Show-Message -fr "JEUX CONFIGURES" -en "CONFIGURED GAMES" -color "Green"
    Write-Host "---------------" -ForegroundColor DarkGray
    foreach ($game in $doneGames | Sort-Object) {
        Write-Host "  [OK] $game" -ForegroundColor Green
    }
    Write-Host ""
}

if ($notInstalledGames.Count -gt 0) {
    Show-Message -fr "JEUX NON TROUVES" -en "GAMES NOT FOUND" -color "Yellow"
    Write-Host "----------------" -ForegroundColor DarkGray
    foreach ($game in $notInstalledGames | Sort-Object) {
        Write-Host "  [X] $game" -ForegroundColor DarkGray
    }
    Write-Host ""
    Show-Message -fr "NOTE: Si ces jeux sont installes ailleurs, deplacez-les" -en "NOTE: If these games are installed elsewhere, move them" -color "Yellow"
    Show-Message -fr "      vers un des emplacements standards pour optimisation." -en "      to one of the standard locations for optimization." -color "Yellow"
}

Write-Host ""
Write-Host "================================================================" -ForegroundColor Cyan
Show-Message -fr "              EXCLUSIONS CONFIGUREES AVEC SUCCES               " -en "              EXCLUSIONS CONFIGURED SUCCESSFULLY                " -color "White"
Write-Host "================================================================" -ForegroundColor Cyan
Write-Host ""

Write-Host ""
Write-Host "================================================================" -ForegroundColor Yellow
Show-Message -fr "                Suppression NVIDIA APP et Pilote Audio          " -en "          Removing NVIDIA APP and Audio Driver                  " -color "White"
Write-Host "================================================================" -ForegroundColor Yellow
Write-Host ""

Show-Message -fr "[INFO] Arret des processus NVIDIA App et Audio Driver et Desinstallation" -en "[INFO] Stopping NVIDIA App and Audio Driver processes and Uninstalling" -color "Cyan"

if (Test-Path "C:\Program Files\NVIDIA Corporation\Installer2\InstallerCore\NVI2.DLL") {
    
    $regPath = "HKLM:\SOFTWARE\Policies\Microsoft\Windows\WindowsUpdate\AU"
    $regBackup = $null
    
    try {
        if (!(Test-Path $regPath)) { 
            New-Item -Path $regPath -Force | Out-Null 
        }
        
        if (Get-ItemProperty -Path $regPath -Name "NoAutoRebootWithLoggedOnUsers" -ErrorAction SilentlyContinue) {
            $regBackup = (Get-ItemProperty -Path $regPath -Name "NoAutoRebootWithLoggedOnUsers").NoAutoRebootWithLoggedOnUsers
        }
        
        Set-ItemProperty -Path $regPath -Name "NoAutoRebootWithLoggedOnUsers" -Value 1 -Type DWord
        
        Show-Message -fr "[INFO] Protection contre le redemarrage activee" -en "[INFO] Reboot protection enabled" -color "Yellow"
        
        Start-Process -FilePath "C:\Windows\SysWOW64\rundll32.exe" `
                      -ArgumentList '"C:\Program Files\NVIDIA Corporation\Installer2\InstallerCore\NVI2.DLL",UninstallPackage Display.NvApp' `
                      -Wait -NoNewWindow
        
        Start-Process -FilePath "C:\Windows\SysWOW64\rundll32.exe" `
                      -ArgumentList '"C:\Program Files\NVIDIA Corporation\Installer2\InstallerCore\NVI2.DLL",UninstallPackage HDAudio.Driver' `
                      -Wait -NoNewWindow
        
        Show-Message -fr "[INFO] Nvidia App et Driver Audio desinstalles avec succes" -en "[INFO] Nvidia App and Audio Driver uninstalled successfully" -color "Cyan"
        
    }
    catch {
        Show-Message -fr "[ERREUR] Probleme lors de la desinstallation: $_" -en "[ERROR] Issue during uninstallation: $_" -color "Red"
    }
    finally {
        if ($null -ne $regBackup) {
            Set-ItemProperty -Path $regPath -Name "NoAutoRebootWithLoggedOnUsers" -Value $regBackup -Type DWord
        }
        else {
            Remove-ItemProperty -Path $regPath -Name "NoAutoRebootWithLoggedOnUsers" -ErrorAction SilentlyContinue
        }
        
        Show-Message -fr "[INFO] Protection contre le redemarrage desactivee" -en "[INFO] Reboot protection disabled" -color "Yellow"
    }
}

Write-Host ""
Write-Host "================================================================" -ForegroundColor Yellow
Show-Message -fr "                    RECOMMANDATIONS FINALES                     " -en "                    FINAL RECOMMENDATIONS                       " -color "White"
Write-Host "================================================================" -ForegroundColor Yellow
Write-Host ""
Show-Message -fr "APPLICATIONS A FERMER:" -en "APPLICATIONS TO CLOSE:" -color "Red"
Write-Host "----------------------" -ForegroundColor DarkGray
Show-Message -fr "  - Yunite (overlay de clips)" -en "  - Yunite (clip overlay)" -color "White"
Show-Message -fr "  - Warlegend (tracker de stats)" -en "  - Warlegend (stats tracker)" -color "White"
Show-Message -fr "  - Toutes applications non essentielles" -en "  - All non-essential applications" -color "White"
Show-Message -fr "  - Navigateurs web non utilises" -en "  - Unused web browsers" -color "White"
Show-Message -fr "  - Discord/TeamSpeak si non necessaire" -en "  - Discord/TeamSpeak if not necessary" -color "White"
Write-Host ""
Show-Message -fr "RAPPEL IMPORTANT:" -en "IMPORTANT REMINDER:" -color "Red"
Write-Host "----------------" -ForegroundColor DarkGray
Show-Message -fr "  NE PAS enregistrer de clips pendant les sessions de jeu" -en "  DO NOT record clips during gaming sessions" -color "White"
Show-Message -fr "  Les overlays et enregistreurs impactent les performances" -en "  Overlays and recorders impact performance" -color "White"
Write-Host ""

Write-Host "================================================================" -ForegroundColor Green
Show-Message -fr "               OPTIMISATION TERMINEE AVEC SUCCES               " -en "               OPTIMIZATION COMPLETED SUCCESSFULLY              " -color "White"
Write-Host "================================================================" -ForegroundColor Green
Write-Host ""
Show-Message -fr "                    ACTION REQUISE:" -en "                    ACTION REQUIRED:" -color "Yellow"
Show-Message -fr "         REDEMARREZ VOTRE ORDINATEUR MAINTENANT" -en "         RESTART YOUR COMPUTER NOW" -color "Yellow"
Write-Host ""
Write-Host "================================================================" -ForegroundColor Green
Write-Host ""

Show-Message -fr "Le script se fermera automatiquement dans 10 secondes..." -en "The script will close automatically in 10 seconds..." -color "Gray"
Start-Sleep -Seconds 10